# Copyright (C) 2013-2023 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 11-May-2023 17:11.

"""capConfig userdefined property type, originally defined in resource file
set apollodev 90:00:01:06:00:00:00:00-4."""


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined


class capConfig(izot.resources.base.Structure):
    """capConfig userdefined property type.  ."""

    def __init__(self):
        super().__init__(
            key=21,
            scope=4
        )

        self.__startupDelay = izot.resources.base.Scaled(
            size=2,
            signed=False,
            minimum=0,
            maximum=65535
        )
        self._register(('startupDelay', self.__startupDelay))

        self.__triggerDelay = izot.resources.base.Scaled(
            size=2,
            signed=False,
            minimum=0,
            maximum=65535
        )
        self._register(('triggerDelay', self.__triggerDelay))

        self.__sampleTime = izot.resources.base.Scaled(
            size=2,
            signed=False,
            minimum=0,
            maximum=65535
        )
        self._register(('sampleTime', self.__sampleTime))

        self.__hysteresis = izot.resources.base.Scaled(
            size=2,
            signed=False,
            scaling=(0.1, 0),
            minimum=0,
            maximum=6553.5
        )
        self._register(('hysteresis', self.__hysteresis))
        self._default_bytes = b'\x07\x08\x04\x80\x00\x3c\x00\x14'
        self._original_name = 'UCPTcapConfig'
        self._property_scope, self._property_key = 4, 21
        self._definition = userdefined.add(self)

    def __set_startupDelay(self, v):
        self.__startupDelay._value = v

    startupDelay = property(
        lambda self: self.__startupDelay._value,
        __set_startupDelay,
        None,
        """Delay after enable 2 before thresholds are checked.  (s)."""
    )

    def __set_triggerDelay(self, v):
        self.__triggerDelay._value = v

    triggerDelay = property(
        lambda self: self.__triggerDelay._value,
        __set_triggerDelay,
        None,
        """Time the thresholds must be exceed before in alarm.  (s)."""
    )

    def __set_sampleTime(self, v):
        self.__sampleTime._value = v

    sampleTime = property(
        lambda self: self.__sampleTime._value,
        __set_sampleTime,
        None,
        """Sample period.  (s)."""
    )

    def __set_hysteresis(self, v):
        self.__hysteresis._value = v

    hysteresis = property(
        lambda self: self.__hysteresis._value,
        __set_hysteresis,
        None,
        """."""
    )

    def __len__(self):
        """Return the length of the type, in bytes."""
        return 8


if __name__ == '__main__':
    # unit test code.
    item = capConfig()
    pass
